#! /system/bin/sh

export APP_PATH=/app
export BIN_PATH=$APP_PATH/bin
export LIB_PATH=$APP_PATH/lib
export SCRIPTS_PATH=$APP_PATH/scripts
export WEB_CONFIG_PATH=$APP_PATH/config

export LD_LIBRARY_PATH+=:$LIB_PATH

pname=$1
script_name=${pname}.sh

echo "Monitor scripts $script_name"
while [ true ]
do
	output=`ps | grep $script_name | grep -v grep` 
	if [ -n "$output" ];then
		sleep 5
		continue
	fi
	
	if [ -f "/tmp/kill_${pname}" ]; then
		break;
	fi
	
	sh $SCRIPTS_PATH/$script_name &
	sleep 5
done

exit 0
