#! /system/bin/sh
# Set app to run
export APP_PATH=/app
export BIN_PATH=$APP_PATH/bin
export LIB_PATH=$APP_PATH/lib
export SCRIPTS_PATH=$APP_PATH/scripts
export WEB_CONFIG_PATH=$APP_PATH/config

export LD_LIBRARY_PATH=$LIB_PATH:$LD_LIBRARY_PATH

busybox chmod 777 -R /app/
busybox chmod 777 -R /var/
busybox chmod 777 -R /tmp/
busybox chmod 777 -R /config/

appName=$1
appParam=$2

while [ true ]
do
if [ "$appName" ]; then
	echo "Ready to run app [$appName $appParam]"
	if [ -f "/tmp/kill_${appName}" ]; then
		break;
	fi
	$BIN_PATH/$appName $appParam
else
	echo "Please run it with a app name"
	exit 0
fi
sleep 1
done

exit 0
