#! /system/bin/sh

# Path
CustomPath=/config/Custom
CustomBackupPath=/info/factory/Custom
FactoryPath=/app/factory/Custom
ResourcePath=/app/resources
WebRootPath=$ResourcePath/www/htdocs

CustomPicture_List="header.png startup2.zip weblogo.png upgradeBg.jpg"
CustomLangWeb_List="ClientTestLang.js Note_ClientTestLang.js"
CustomLangLcd_List="ClientTestLang_LCD.txt"

# Function
function CustomBackup ()
{
	backupPath=$1
	backupName=$2
	echo "Backup: cp -rf $CustomPath/$backupPath/$backupName $CustomBackupPath/$backupPath/$backupName"
	cp -rf $CustomPath/$backupPath/$backupName $CustomBackupPath/$backupPath/$backupName
    chmod 666 $CustomBackupPath/$backupPath/$backupName
}

function CustomRecover ()
{
	recoverPath=$1
	recoverName=$2
	echo "Recover: cp -rf $CustomBackupPath/$recoverPath/$recoverName $CustomPath/$recoverPath/$recoverName"
	cp -rf $CustomBackupPath/$recoverPath/$recoverName $CustomPath/$recoverPath/$recoverName
	chmod 666 $CustomPath/$recoverPath/$recoverName
}

function CustomFactory ()
{
	factoryPath=$1
	factoryName=$2
	echo "Factory: cp -rf $FactoryPath/$factoryPath/$factoryName $CustomPath/$factoryPath/$factoryName"
	cp -rf $FactoryPath/$factoryPath/$factoryName $CustomPath/$factoryPath/$factoryName
	chmod 666 $CustomPath/$factoryPath/$factoryName
}

function CustomInstall ()
{
	installPath=$1
	installName=$2
	echo "installPath = $installPath ## installName = $installName"
	if [ -f $CustomPath/$installPath/$installName ]; then
		CustomBackup $installPath $installName
#	elif [ -f $CustomBackupPath/$installPath/$installName ]; then
#		CustomRecover $installPath $installName
	elif [ -f $FactoryPath/$installPath/$installName ]; then
		CustomFactory $installPath $installName
	else
		echo "Do nothing~"
	fi
}

function CustomReplace ()
{
	srcFile=$1
	destFile=$2
	if [ -f $srcFile ]; then
		echo "rm -rf $destFile"
		echo "ln -sf $srcFile $destFile"
		rm -rf $destFile
		ln -sf $srcFile $destFile
	fi
}

# Create directory for Custom
mkdir -p $CustomPath/Pictures
mkdir -p $CustomPath/Lang/Web
mkdir -p $CustomPath/Lang/LCD

# Create directory for CustomBackup
mkdir -p $CustomBackupPath/Pictures
mkdir -p $CustomBackupPath/Lang/Web
mkdir -p $CustomBackupPath/Lang/LCD

# Install Pictures
for curItem in $CustomPicture_List
do
	CustomInstall Pictures $curItem
done

# Install Lang/Web
for curItem in $CustomLangWeb_List
do
	CustomInstall Lang/Web $curItem
done

# Install Lang/LCD
for curItem in $CustomLangLcd_List
do
	CustomInstall Lang/LCD $curItem
done

# Replace Web Header
CustomReplace $CustomPath/Pictures/header.png $WebRootPath/Image/head.png

# Replace Web Body-Lang
CustomReplace $CustomPath/Lang/Web/ClientTestLang.js $WebRootPath/lang/En.js

# Replace Web Note-Lang
CustomReplace $CustomPath/Lang/Web/Note_ClientTestLang.js $WebRootPath/note/Note_En.js

# Replace Lcd Lang
CustomReplace $CustomPath/Lang/LCD/ClientTestLang_LCD.txt $ResourcePath/Language/ENGLISH.txt

chmod 777 -R /config/
