#! /system/bin/sh
# Set app to run
export FS_PATH=/app/bin
export FS_BIN_PATH=$FS_PATH/freeswitch/bin
export FS_LIB_PATH=$FS_PATH/freeswitch/lib
export LD_LIBRARY_PATH=$FS_LIB_PATH

busybox chmod 777 -R /app/
busybox chmod 777 -R /app/freeswitch/
busybox chmod 777 -R /var/
busybox chmod 777 -R /tmp/
busybox chmod 777 -R /config/

appName=$1
appParam=$2

# while [ true ]
# do
# 	if [ -f "/tmp/boot_finished" ]; then
# 		break
# 	fi
# 	sleep 1
# done

while [ true ]
do
if [ "$appName" ]; then
	echo "Ready to run app [$appName $appParam]"
	if [ -f "/tmp/kill_${appName}" ]; then
		break;
	fi
	
	startfs=`getprop persist.freeswitch.start`
	
	if [ "$startfs" == "1" ]; then
	   $FS_BIN_PATH/$appName $appParam
	else
	  echo "Please start fs with setprop persist.freeswitch.start 1"
	  break;
	fi
else
	echo "Please run it with a app name"
	exit 0
fi
sleep 1
done

exit 0
